local assets =
{
    Asset("ANIM", "anim/roncatolive.zip"),
    Asset("ANIM", "anim/roncatolive_anim.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatolive.xml"),
	Asset("ATLAS", "images/inventoryimages/roncatolive_cooked.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end

    inst.AnimState:SetBank("roncatolive")
    inst.AnimState:SetBuild("roncatolive")
    inst.AnimState:PlayAnimation("idle")
	
	--cookable (from cookable component) added to pristine state for optimization
	inst:AddTag("cookable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("tradable")

    inst:AddComponent("inspectable")

    MakeSmallBurnable(inst, TUNING.TINY_BURNTIME)
    MakeSmallPropagator(inst)
	if IsDLCEnabled(REIGN_OF_GIANTS) then
		inst.components.burnable:MakeDragonflyBait(3)
	end

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatolive.xml"

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = TUNING.HEALING_MEDSMALL
    inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
    inst.components.edible.sanityvalue = 0	
	inst.components.edible.foodtype = "VEGGIE"

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	
	inst:AddComponent("bait")

	inst:AddComponent("cookable")
	inst.components.cookable.product = "roncatolive_cooked"

    return inst
end


local function fncooked()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "cooked_water", "cooked")
	end

    inst.AnimState:SetBank("roncatolive")
    inst.AnimState:SetBuild("roncatolive")
    inst.AnimState:PlayAnimation("cooked")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("tradable")

    inst:AddComponent("inspectable")

    MakeSmallBurnable(inst, TUNING.TINY_BURNTIME)
    MakeSmallPropagator(inst)
	if IsDLCEnabled(REIGN_OF_GIANTS) then
		inst.components.burnable:MakeDragonflyBait(3)
	end

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatolive_cooked.xml"

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = TUNING.HEALING_MED
    inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
    inst.components.edible.sanityvalue = 0
	inst.components.edible.foodtype = "VEGGIE"

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	
	inst:AddComponent("bait")

    return inst
end

AddIngredientValues({"roncatolive"}, {fruit=1}, true)
AddIngredientValues({"roncatolive_cooked"}, {fruit=1}, true)

return Prefab("common/inventory/roncatolive", fn, assets),
	Prefab("common/inventory/roncatolive_cooked", fncooked, assets)